'use strict';

angular.module('offers_model', ['configuration_model'])
    .factory('Offer', ['$http', '$rootScope', 'Configuration', function($http, $rootScope, Configuration){
        function Offer(data){
            this.setData(data);
        }

        Offer.prototype = {
            _bought: false
            ,_checked: false
            ,setData: function(data){
                angular.extend(this, data);
                this._originalValue = angular.copy(this.value);
            }
            ,isBought: function(){
                return this._bought;
            }
            ,isChecked: function(){
                return this._checked;
            }
            ,setChecked: function(checked){
                this._checked = checked;
                if(!this._checked){
                    this.children.forEach(function(children){
                        children.setChecked(false);
                    });
                }
            }
            ,save: function(callbackSuccess, callbackError){
                var scope = this;
                $http.post(Configuration.urlOffers, this)
                    .success(function(data){
                        callbackSuccess(data);
                        scope._bought = true;
                        scope._checked = false;
                    })
                    .error(function(data){
                        callbackError(data);
                        scope._bought = false;
                        scope._checked = false;
                    })
                ;
            }
        }

        return Offer;
    }])
    .factory('OffersList', ['$http', '$q', 'Configuration', 'Offer', function($http, $q, Configuration, Offer){
        var OffersList = {
            _isLoadedData: false
            ,_list: []
            ,loadData: function(){
                if(this._isLoadedData)
                {
                    return this._list;
                }

                var defer = $q.defer();
                var scope = this;

                $http.get(Configuration.urlOffers)
                    .success(function(data){
                        scope._list = [];
                        data.availableOffers.forEach(function(offerData){
                            offerData._bought = (data.boughtIds.indexOf(offerData.id) > -1);
                            scope._list.push(new Offer(offerData));
                            for(var i=0;i<offerData.children.length;i++){
                                offerData.children[i] = new Offer(offerData.children[i]);
                                offerData.children[i]._bought = (data.boughtIds.indexOf(offerData.children[i].id) > -1);
                            }
                        });
                        scope._isLoadedData = true;
                        defer.resolve(scope._list);
                    })
                    .error(function(data){
                        defer.reject();
                    })
                ;

                return defer.promise;
            }
            ,isAnyToBuy: function(){
                var isToBuy = false;
                for(var i = 0; i < this._list.length; i++)
                {
                    if(!this._list[i].isBought())
                    {
                        isToBuy = true;
                        break;
                    }
                }

                return isToBuy;
            }
            ,isAnyBought: function(){
                var isBought = false;
                for(var i = 0; i < this._list.length; i++)
                {
                    if(this._list[i].isBought())
                    {
                        isBought = true;
                        break;
                    }
                }

                return isBought;
            }
        };

        return OffersList;
    }])
;